﻿// FORMAT:  3


// get tileSize
formats[3].get.tileSize = function(){
	return current.data.tileSize;
}
// get map's width
formats[3].get.width = function(){
	return current.data.width;
}
// get map's height
formats[3].get.height = function(){
	return current.data.height;
}
// get tile's chipset index
formats[3].get.tileChipIndex = function( location ){
	var thisTile = current.data.layers[location.layer][location.x][location.y];
	return thisTile.chipset;
}
// get quantity of chipsets
formats[3].get.chipsetQuantity = function(){
	return current.data.chipsets.length;
}
// get maximum allowed quantity of chipsets
formats[3].get.maxChipsetQuantity = function(){
	return 36;
}
// get maximum supported chipset size, in tiles		(max quantity of tiles horz & vert)
formats[3].get.maxChipsetSize = function(){
	return {
		width: 36,
		height: 36
	}// {}
}
// get quantity of layers
formats[3].get.layerQuantity = function(){
	return current.data.layers.length;
}
// get chipset's file
formats[3].get.chipsetFile = function( chipsetIndex ){
	return current.data.chipsets[chipsetIndex];
}
// get copy of all chipset data for selection data
formats[3].get.allChipsets = function(){
	return current.data.chipsets.slice();		// clone the array
}
// get tile data  (returns a copy)
formats[3].get.tile = function( location ){
	var thisTile = current.data.layers[location.layer][location.x][location.y];
	return {
		chipset: thisTile.chipset,
		x: thisTile.x,
		y: thisTile.y
	}
}
// get all map data
formats[3].get.data = function(){
	return current.data;
}
// get collision value of a tile
formats[3].get.collisionTile = function( loc ){
	return current.data.collision[loc.x][loc.y];
}





// set tileSize
formats[3].set.tileSize = function( newTileSize ){
	current.data.tileSize = newTileSize;
}


// set map's width
formats[3].set.width = function( newWidth ){
	if(newWidth == current.data.width )		return;		// same width = do nothing
	var xDiff = Math.abs(current.data.width - newWidth);
	
	// tiles
	for(var l=0; l<current.data.layers.length; l++){
		var thisGrid = current.data.layers[l];
		if(newWidth > current.data.width )
		{// if:  wider
			// // create new columns
			var newColumns = [];
			for(var xx=0; xx<xDiff; xx++){
				newColumns[xx] = [];
				for(var yy=0; yy<current.data.height; yy++){
					newColumns[xx][yy] = data.create.blankTile();
				}// for:  map's height
			}// for:  added width
			// // add new columns to the right
			thisGrid.splice.apply( thisGrid, [thisGrid.length, 0].concat(newColumns) );
		}// if:  wider
		if(newWidth < current.data.width )
		{// if:  narrower
			// // remove columns from the right
			thisGrid.splice( -xDiff, xDiff );
		}// if:  narrower
	}// for:  each layer
	
	
	// collision
	var thisGrid = current.data.collision;
	if(newWidth > current.data.width)
	{// if:  wider
		// // create new columns
		var newColumns = [];
		for(var xx=0; xx<xDiff; xx++){
			newColumns[xx] = [];
			for(var yy=0; yy<current.data.height; yy++){
				newColumns[xx][yy] = data.create.blankCollisionValue();
			}// for:  map's height
		}// for:  added width
		// // add new columns to the right
		thisGrid.splice.apply( thisGrid, [thisGrid.length, 0].concat(newColumns) );
	}// if:  wider
	if(newWidth < current.data.width )
	{// if:  narrower
		// // remove columns from the right
		thisGrid.splice( -xDiff, xDiff );
	}// if:  narrower
	
	current.data.width = newWidth;
}// set width()



// set map's height
formats[3].set.height = function( newHeight ){
	if(newHeight == current.data.height)		return;		// same height = do nothing
	var yDiff = Math.abs(current.data.height - newHeight);
	
	// tiles
	for(var l=0; l<current.data.layers.length; l++){
		var thisGrid = current.data.layers[l];
		for(var xx=0; xx<current.data.width; xx++){
			var thisColumn = thisGrid[xx];
			
			if(newHeight > current.data.height)
			{// if:  taller
				// // create new tiles
				var newTiles = [];
				for(var yy=0; yy<yDiff; yy++){
					newTiles[yy] = data.create.blankTile();
				}// for:  added height
				// // add new columns to the bottom
				thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat( newTiles) );
			}// if:  taller
			
			if(newHeight < current.data.height)
			{// if:  shorter
				// // remove columns from the bottom
				thisColumn.splice( -yDiff, yDiff );
			}// if:  shorter
		}// for:  map's width
	}// for:  each layer
	
	
	// collision
	var thisGrid = current.data.collision;
	for(var xx=0; xx<current.data.width; xx++){
		var thisColumn = thisGrid[xx];
		
		if(newHeight > current.data.height)
		{// if:  taller
			// // create new tiles
			var newTiles = [];
			for(var yy=0; yy<yDiff; yy++){
				newTiles[yy] = data.create.blankCollisionValue();
			}// for:  added height
			// // add new columns to the bottom
			thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat( newTiles) );
		}// if:  taller
		
		if(newHeight < current.data.height)
		{// if:  shorter
			// // remove columns from the bottom
			thisColumn.splice( -yDiff, yDiff );
		}// if:  shorter
	}// for:  map's width
	
	current.data.height = newHeight;
}// set height()


// set chipset's file
formats[3].set.chipsetFile = function( chipsetIndex, filePath ){
	current.data.chipsets[chipsetIndex] = filePath;
}
// set tile data
formats[3].set.tile = function( location, tileData ){
	current.data.layers[location.layer][location.x][location.y] = {
		chipset: tileData.chipset,
		x: tileData.x,
		y: tileData.y
	}
}
// set tile's chipset index
formats[3].set.tileChipIndex = function( location, newChipIndex ){
	current.data.layers[location.layer][location.x][location.y].chipset = newChipIndex;
}
// set all chipset files
formats[3].set.allChipsets = function( chipFile_array ){
	current.data.chipsets = chipFile_array.slice();
}
// replace internal data
formats[3].set.data = function( newData ){
	// if:  very old map file
	if( newData.format == undefined ){
		newData.format = 1;		// very old maps were never compressed
	}// if:  very old map file
	
	if(newData.format === current.data.format){
		// ensure that it is un-compressed data
		newData = formats[3].create.uncompressedMap( newData );
		current.data = newData;
	}else{
		changeFormat( newData.format );
		// prevent the new interface's set.data() from reacting to this particular format change
		current.data = {};		// current data might not exist yet
		current.data.format = newData.format;
		// call the new interface's set.data() command
		data.set.data( newData );
	}
}
// set collision value of a tile
formats[3].set.collisionTile = function( loc, newValue ){
	current.data.collision[loc.x][loc.y] = newValue;
}


// add chipset at
formats[3].add.chipset = function( chipIndex, chipFile ){
	current.data.chipsets.splice( chipIndex, 0, chipFile );
}
// add layer at
formats[3].add.layer = function( layerIndex, tileData ){
	var newTile = tileData || data.create.blankTile();
	var newLayer = [];
	for(var xx=0; xx<data.get.width(); xx++){
		newLayer[xx] = [];
		for(var yy=0; yy<data.get.height(); yy++){
			newLayer[xx][yy] = data.copy.tile( newTile );
		}// for:  height
	}// for:  width
	current.data.layers.splice( layerIndex, 0, newLayer );
}


// remove chipset at
formats[3].remove.chipset = function( chipIndex ){
	current.data.chipsets.splice( chipIndex, 1 );
}
// remove layer at
formats[3].remove.layer = function( chipIndex ){
	current.data.layers.splice( chipIndex, 1 );
}


// create tile data  (blank)
formats[3].create.blankTile = function(){
	return {
		chipset: 0,
		x: 0,
		y: 0
	}
}

// create tile from chipset
formats[3].create.tileFromChipset = function( xChip, yChip, chipIndex ){
	return {
		chipset: chipIndex,
		x: xChip,
		y: yChip
	}
}

// create new map data
formats[3].create.map = function( width, height, tileSize, format ){
	var output = {};
	
	var width = width || 20;
	var height = height || 15;
	var format = format || 3;
	
	if(format !== 3){
		// call the create.map() function for that format
		return formats[format].create.map.apply( this, arguments );
	}// if:  different format
	
	// default values
	var newChipset = 0;
	var newChipX = 0;
	var newChipY = 0;
	var newChipFile = "chipset\\basis.png";
	
	// containers
	output.chipsets = [];
	output.collision = [];
	output.layers = [];
	
	// root variables
	output.format = 3;
	output.isCompressed = false;
	output.tileSize = tileSize || 16;
	output.width = width;
	output.height = height;
	
	// chipset files
	output.chipsets[0] = newChipFile;
	
	// construct un-compressed collision data
	var collisionColumn = [];
	for(var yy=0; yy<output.height; yy++){
		collisionColumn[yy] = data.create.blankCollisionValue();
	}// for:  height
	for(var xx=0; xx<output.width; xx++){
		output.collision[xx] = collisionColumn.slice();		// clone this column of collision data
	}// for:  width
	
	// construct un-compressed tile data
	output.layers[0] = [];
	for(var xx=0; xx<output.width; xx++){
		output.layers[0][xx] = new Array( output.height );
		for(var yy=0; yy<output.height; yy++){
			var thisTile = output.layers[0][xx][yy] = {};
			thisTile.chipset = newChipset;
			thisTile.x = newChipX;
			thisTile.y = newChipY;
		}// for:  height
	}// for:  width
	
	return output;
}// create map()



// create un-compressed collision data
formats[3].create.compressedCollision = function( uncompressedCollision, width, height ){
	var colWidth = width || uncompressedCollision.length;
	var colHeight = height || uncompressedCollision[0].length;
	// compress collision
	// create "collision" string
	compressedCollision = "";
	for(var yy=0; yy<colHeight; yy++)
	{// for:  height
		for(var xx=0; xx<colWidth; xx++)
		{// for:  width
			var colValue10 = uncompressedCollision[xx][yy];
			// convert tile:  base-10 => base-16
			var colValue36 = colValue10.toString( 36 );
			// append tile to collision string
			compressedCollision += colValue36;
		}// for:  width
	}// for:  height
	return compressedCollision;
}// create compressed collision()



// create compressed collision data
formats[3].create.uncompressedCollision = function( compressedCollision, width, height ){
	var colWidth = width;
	var colHeight = height;
	// de-compress collision
	// create 2D array  (width x height)
	var newCollision = [];
	for(var xx=0; xx<colWidth; xx++){
		newCollision[xx] = [];
		for(var yy=0; yy<colHeight; yy++){
			// get read offset
			var readFrom = (colWidth *yy) +xx;
			// decode that character  (base-36 => base-10 decimal)
			// store as a decimal number in that tile-location
			newCollision[xx][yy] = parseInt( compressedCollision.charAt(readFrom), 36 );
		}// for:  height
	}// for:  width
	return newCollision;
}// create un-compressed collision()



// create un-compressed map data, from compressed map data
formats[3].create.uncompressedMap = function( compressedData ){
	
	var format = compressedData.format;
	if(format !== 3){
		// call the create.map() function for that format
		return formats[format].create.uncompressedMap.apply( this, arguments );
	}// if:  different format
	
	// if:   already un-compressed,  then return the same data
	if( compressedData.isCompressed === false )		return compressedData;
	
	var newData = {};
	
	// copy root data
	newData.format = compressedData.format;
	newData.isCompressed = false;
	newData.tileSize = compressedData.tileSize;
	newData.width = compressedData.width;
	newData.height = compressedData.height;
	// copy chipsets as-is
	newData.chipsets = compressedData.chipsets.slice();
	
	// de-compress tiles
	var tileLength = 3;
	newData.layers = [];
	for(var l=0; l<compressedData.layers.length; l++)
	{// for:  each layer
		newData.layers[l] = [];
		// create 2D array  (width x height)
		for(var xx=0; xx<compressedData.width; xx++){
			newData.layers[l][xx] = [];
			for(var yy=0; yy<compressedData.height; yy++){
				// get read offset
				var readFrom = ((compressedData.width *yy) +xx) *tileLength;
				// decode each character  (base-36 => base-10 decimal)
				// store as {chipset, x, y} in that tile-location
				newData.layers[l][xx][yy] = {
					chipset: parseInt( compressedData.layers[l].charAt(readFrom), 36 ),	// base-36 => base-10
					x: parseInt( compressedData.layers[l].charAt(readFrom+1), 36 ),			// base-36 => base-10
					y: parseInt( compressedData.layers[l].charAt(readFrom+2), 36 )				// base-36 => base-10
				};// {} new tile data
			}// for:  height
		}// for:  width
	}// for:  each layer
	
	// de-compress collision
	newData.collision = formats[3].create.uncompressedCollision( compressedData.collision, compressedData.width, compressedData.height );
	/*
	// create 2D array  (width x height)
	newData.collision = [];
	for(var xx=0; xx<compressedData.width; xx++){
		newData.collision[xx] = [];
		for(var yy=0; yy<compressedData.height; yy++){
			// get read offset
			var readFrom = (compressedData.width *yy) +xx;
			// decode that character  (base-36 => base-10 decimal)
			// store as a decimal number in that tile-location
			newData.collision[xx][yy] = parseInt( compressedData.collision.charAt(readFrom), 36 );
		}// for:  height
	}// for:  width
	*/
	return newData;
}// create uncompressedMap()


// create compressed map data, from un-compressed map data
formats[3].create.compressedMap = function( uncompressedData ){
	
	var format = uncompressedData.format;
	if(format !== 3){
		// call the create.map() function for that format
		return formats[format].create.compressedMap.apply( this, arguments );
	}// if:  different format
	
	// if:   already compressed,  then return the same data
	if( uncompressedData.isCompressed === true )		return uncompressedData;
	
	var newData = {};
	
	// copy root data
	newData.format = uncompressedData.format;
	newData.isCompressed = true;
	newData.tileSize = uncompressedData.tileSize;
	newData.width = uncompressedData.width;
	newData.height = uncompressedData.height;
	// copy chipsets as-is
	newData.chipsets = uncompressedData.chipsets.slice();
	
	// compress tiles
	// create "layers" array
	newData.layers = [];
	for(var l=0; l<uncompressedData.layers.length; l++)
	{// for:  each layer
		// create this layer's string
		newData.layers[l] = "";
		for(var yy=0; yy<uncompressedData.height; yy++)
		{// for:  height
			for(var xx=0; xx<uncompressedData.width; xx++)
			{// for:  width
				var readTile = uncompressedData.layers[l][xx][yy];
				// convert chipset base-10 => base-16
				var c = readTile.chipset.toString( 36 );
				// convert x base-10 => base-16
				var x = readTile.x.toString( 36 );
				// convert y base-10 => base-16
				var y = readTile.y.toString( 36 );
				// append string
				newData.layers[l] += c + x + y;
			}// for:  width
		}// for:  height
	}// for:  each layer
	
	// compress collision
	newData.collision = formats[3].create.compressedCollision( uncompressedData.collision, uncompressedData.width, uncompressedData.height );
	/*
	// create "collision" string
	newData.collision = "";
	for(var yy=0; yy<uncompressedData.height; yy++)
	{// for:  height
		for(var xx=0; xx<uncompressedData.width; xx++)
		{// for:  width
			var colValue10 = uncompressedData.collision[xx][yy];
			// convert tile:  base-10 => base-16
			var colValue36 = colValue10.toString( 36 );
			// append tile to collision string
			newData.collision += colValue36;
		}// for:  width
	}// for:  height
	*/
	return newData;
}// create compressedMap()

// create collision value  (blank  AKA  value 0)
formats[3].create.blankCollisionValue = function(){
	return 0;
}// create blank collision value()



// create tile data... from selection tile data		(redundant, because they use the same format)
formats[3].copy.tile = function( tileData ){
	return {
		chipset: tileData.chipset,
		x: tileData.x,
		y: tileData.y
	}
}



// shift tiles
formats[3].modify.shiftTilesHorz = function( xOffset ){
	if(xOffset === 0)		return;		// Do nothing
	var numTilesX = Math.abs(xOffset);
	if(numTilesX > data.get.width())		numTilesX = data.get.width();
	
	// shift tiles
	for(var l=0; l<current.data.layers.length; l++)
	{// for:  each layer
		// shift horz
		var thisRow = current.data.layers[l];
		// create new tiles  (as a 2D array)
		var newCols = [];
		for(var cx=0; cx<numTilesX; cx++){
			newCols[cx] = [];
			for(var cy=0; cy<current.data.height; cy++){
				newCols[cx][cy] = formats[3].create.blankTile();
			}// for:  height of a column
		}// for:  horz tiles to add
		// shift left
		if(xOffset < 0){
			// remove tiles from the left
			thisRow.splice(0, numTilesX);
			// add new columns to the right
			thisRow.splice.apply( thisRow, [thisRow.length,0].concat(newCols) );
		}
		// shift right
		if(xOffset > 0){
			// remove tiles from the right
			thisRow.splice(-numTilesX, numTilesX);
			// add new tiles to the left
			thisRow.splice.apply( thisRow, [0,0].concat(newCols) );
		}
	}// for:  each layer
	
	// shift collision
	// shift horz
	var thisRow = current.data.collision;
	// create new tiles  (as a 2D array)
	var newCols = [];
	for(var cx=0; cx<numTilesX; cx++){
		newCols[cx] = [];
		for(var cy=0; cy<current.data.height; cy++){
			newCols[cx][cy] = data.create.blankCollisionValue();
		}// for:  height of a column
	}// for:  horz tiles to add
	// shift left
	if(xOffset < 0){
		// remove tiles from the left
		thisRow.splice(0, numTilesX);
		// add new columns to the right
		thisRow.splice.apply( thisRow, [thisRow.length,0].concat(newCols) );
	}
	// shift right
	if(xOffset > 0){
		// remove tiles from the right
		thisRow.splice(-numTilesX, numTilesX);
		// add new tiles to the left
		thisRow.splice.apply( thisRow, [0,0].concat(newCols) );
	}
}// modify shiftTilesHorz()


formats[3].modify.shiftTilesVert = function( yOffset ){
	if(yOffset === 0)		return;		// Do nothing
	var numTilesY = Math.abs(yOffset);
	if(numTilesY > data.get.height())		numTilesY = data.get.height();
	
	// shift tiles
	for(var l=0; l<current.data.layers.length; l++)
	{// for:  each layer
		// shift vert
		for(var xx=0; xx<current.data.width; xx++)
		{// for:  width
			// create Y new tiles  (as an array)
			var newCol = [];
			for(var t=0; t<numTilesY; t++){
				newCol[t] = formats[3].create.blankTile();
			}
			var thisColumn = current.data.layers[l][xx];
			// shift up
			if(yOffset < 0){
				// remove Y tiles from the top
				thisColumn.splice(0,numTilesY);
				// add new tiles to the bottom
				thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat(newCol) );
			}
			// shift down
			if(yOffset > 0){
				// remove Y tiles from the bottom
				thisColumn.splice(-numTilesY,numTilesY);
				// add new tiles to the top
				thisColumn.splice.apply( thisColumn, [0,0].concat(newCol) );
			}
		}// for:  width
	}// for:  each layer
	
	
	
	// shift collision
	// shift vert
	for(var xx=0; xx<current.data.width; xx++)
	{// for:  width
		// create Y new tiles  (as an array)
		var newCol = [];
		for(var t=0; t<numTilesY; t++){
			newCol[t] = data.create.blankCollisionValue();
		}
		var thisColumn = current.data.collision[xx];
		// shift up
		if(yOffset < 0){
			// remove Y tiles from the top
			thisColumn.splice(0,numTilesY);
			// add new tiles to the bottom
			thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat(newCol) );
		}
		// shift down
		if(yOffset > 0){
			// remove Y tiles from the bottom
			thisColumn.splice(-numTilesY,numTilesY);
			// add new tiles to the top
			thisColumn.splice.apply( thisColumn, [0,0].concat(newCol) );
		}
	}// for:  width
}// modify shiftTilesVert()




	
// wrap tiles  (horizontally)
formats[3].modify.wrapTilesHorz = function( xOffset ){
	if(xOffset === 0)		return;		// Do nothing
	var numTilesX = Math.abs(xOffset);
	// limit to map size
	while(xOffset < 0){
		xOffset += data.get.width();
	}
	xOffset %= data.get.width();
	
	// wrap tiles
	for(var l=0; l<current.data.layers.length; l++){
		var thisGrid = current.data.layers[l];
		// wrap right
		if(xOffset > 0){
			// remove columns from the right side
			var removed = thisGrid.splice( -numTilesX, numTilesX );
			// add these columns to the left side
			thisGrid.splice.apply( thisGrid, [0,0].concat(removed) );
		}// if:  wrap right
		/*
		// wrap left
		if(xOffset < 0){
			// remove columns from the left side
			var removed = thisGrid.splice( 0, numTilesX );
			// add these columns to the right side
			thisGrid.splice.apply( thisGrid, [thisGrid.length,0].concat(removed) );
		}// if:  wrap left
		*/
	}// for:  each layer
	
	// wrap collision
	var thisGrid = current.data.collision;
	// wrap right
	if(xOffset > 0){
		// remove columns from the right side
		var removed = thisGrid.splice( -numTilesX, numTilesX );
		// add these columns to the left side
		thisGrid.splice.apply( thisGrid, [0,0].concat(removed) );
	}// if:  wrap right
	/*
	// wrap left
	if(xOffset < 0){
		// remove columns from the left side
		var removed = thisGrid.splice( 0, numTilesX );
		// add these columns to the right side
		thisGrid.splice.apply( thisGrid, [thisGrid.length,0].concat(removed) );
	}// if:  wrap left
	*/
}// modify wrapTilesHorz()


// wrap tiles  (vertically)
formats[3].modify.wrapTilesVert = function( yOffset ){
	if(yOffset === 0)		return;		// Do nothing
	var numTilesY = Math.abs(yOffset);
	// limit to map size
	while(yOffset < 0){
		yOffset += data.get.height();
	}
	yOffset %= data.get.height();
	
	// wrap tiles
	for(var l=0; l<current.data.layers.length; l++){
		var thisGrid = current.data.layers[l];
		// wrap down
		if(yOffset > 0){
			for(var xx=0; xx<current.data.width; xx++){
				var thisColumn = thisGrid[xx];
				// remove tiles from the bottom
				var removed = thisColumn.splice( -numTilesY, numTilesY );
				// add these tiles to the top
				thisColumn.splice.apply( thisColumn, [0,0].concat(removed) );
			}// for:  width
		}// if:  wrap down
		/*
		// wrap up
		if(yOffset < 0){
			for(var xx=0; xx<current.data.width; xx++){
				var thisColumn = thisGrid[xx];
				// remove tiles from the top
				var removed = thisColumn.splice( 0, numTilesY );
				// add these tiles to the bottom
				thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat(removed) );
			}// for:  width
		}// if:  wrap up
		*/
	}// for:  each layer
	
	// wrap collision
	var thisGrid = current.data.collision;
	// wrap down
	if(yOffset > 0){
		for(var xx=0; xx<current.data.width; xx++){
			var thisColumn = thisGrid[xx];
			// remove tiles from the bottom
			var removed = thisColumn.splice( -numTilesY, numTilesY );
			// add these tiles to the top
			thisColumn.splice.apply( thisColumn, [0,0].concat(removed) );
		}// for:  width
	}// if:  wrap down
	/*
	// wrap up
	if(yOffset < 0){
		for(var xx=0; xx<current.data.width; xx++){
			var thisColumn = thisGrid[xx];
			// remove tiles from the top
			var removed = thisColumn.splice( 0, numTilesY );
			// add these tiles to the bottom
			thisColumn.splice.apply( thisColumn, [thisColumn.length,0].concat(removed) );
		}// for:  width
	}// if:  wrap up
	*/
}// modify wrapTilesVert()